<?php

use App\Models\User;
use App\Models\WalletTransaction;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Reset Test User
User::where('email', 'test122@example.com')->delete();

$user = User::create([
    'name' => 'Test 122',
    'email' => 'test122@example.com',
    'password' => bcrypt('password'),
]);

// Deposit 122 USDT
WalletTransaction::create([
    'user_id' => $user->id,
    'crypto' => 'USDT',
    'amount' => 122,
    'type' => 'deposit',
    'status' => 'approved',
    'source' => 'user'
]);

// Check Balance of USDT
$bal = $user->getAvailableBalance('USDT');
echo "USDT Balance: " . $bal . "\n";

// Check simulated Total Balance (pure logic check)
// Assuming only USDT, Total Balance = 122 * 1 = 122.
echo "Total Balance Logic Check: " . ($bal * 1) . "\n";

// Cleanup
$user->walletTransactions()->delete();
$user->delete();
