<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Email - CoinSova</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 20px;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            text-align: center;
            position: relative;
        }
        .logo-container {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .logo-img {
            width: 60px;
            height: 60px;
            object-fit: contain;
        }
        .header h1 {
            color: white;
            font-size: 32px;
            font-weight: 800;
            margin-bottom: 10px;
            letter-spacing: 1px;
        }
        .header p {
            color: rgba(255,255,255,0.9);
            font-size: 16px;
            font-weight: 300;
        }
        .content {
            padding: 50px 40px;
            background: white;
        }
        .greeting {
            font-size: 24px;
            color: #333;
            margin-bottom: 20px;
            font-weight: 600;
        }
        .message {
            color: #666;
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 30px;
        }
        .code-section {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            margin: 30px 0;
            border: 2px dashed #667eea;
        }
        .code-label {
            color: #667eea;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 15px;
        }
        .verification-code {
            font-size: 48px;
            font-weight: 800;
            color: #667eea;
            letter-spacing: 12px;
            font-family: 'Courier New', monospace;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        .expiry-notice {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px 20px;
            margin: 30px 0;
            border-radius: 8px;
        }
        .expiry-notice p {
            color: #856404;
            font-size: 14px;
            margin: 0;
        }
        .motivation {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin: 30px 0;
            text-align: center;
        }
        .motivation h3 {
            font-size: 22px;
            margin-bottom: 15px;
            font-weight: 700;
        }
        .motivation p {
            font-size: 16px;
            line-height: 1.6;
            opacity: 0.95;
        }
        .features {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin: 30px 0;
        }
        .feature {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
        }
        .feature-icon {
            font-size: 32px;
            margin-bottom: 10px;
        }
        .feature-text {
            color: #666;
            font-size: 14px;
            font-weight: 600;
        }
        .footer {
            background: #f8f9fa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }
        .footer p {
            color: #6c757d;
            font-size: 13px;
            margin: 5px 0;
        }
        .social-links {
            margin: 20px 0;
        }
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .security-note {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .security-note p {
            color: #0c5460;
            font-size: 13px;
            margin: 0;
        }
    </style>
        <div class="content">
            <div class="greeting">Welcome, {{ $user->name }}! 🎉</div>
            
            <p class="message">
                Thank you for joining <strong>CoinSova</strong> - where professional traders execute fast, secure, and profitable cryptocurrency trades with deep liquidity and cutting-edge technology.
            </p>

            <p class="message">
                You're just one step away from accessing the most powerful trading platform. Please verify your email address using the code below:
            </p>

            <!-- Verification Code -->
            <div class="code-section">
                <div class="code-label">Your Verification Code</div>
                <div class="verification-code">{{ $code }}</div>
            </div>

            <!-- Expiry Notice -->
            <div class="expiry-notice">
                <p>⏰ <strong>Important:</strong> This code will expire in 10 minutes for your security.</p>
            </div>

            <!-- Motivation Section -->
            <div class="motivation">
                <h3>🚀 Start Your Trading Journey Today!</h3>
                <p>
                    Join thousands of successful traders who trust CoinSova for their cryptocurrency trading needs. 
                    Execute trades with lightning speed, leverage advanced analytics, and maximize your profits 
                    with our professional-grade platform.
                </p>
            </div>

            <!-- Features -->
            <div class="features">
                <div class="feature">
                    <div class="feature-icon">⚡</div>
                    <div class="feature-text">Lightning Fast Trades</div>
                </div>
                <div class="feature">
                    <div class="feature-icon">🔒</div>
                    <div class="feature-text">Bank-Level Security</div>
                </div>
                <div class="feature">
                    <div class="feature-icon">📊</div>
                    <div class="feature-text">Advanced Analytics</div>
                </div>
                <div class="feature">
                    <div class="feature-icon">💰</div>
                    <div class="feature-text">High Liquidity</div>
                </div>
            </div>

            <!-- Security Note -->
            <div class="security-note">
                <p>
                    🔐 <strong>Security Tip:</strong> Never share this verification code with anyone. 
                    CoinSova will never ask for your verification code via phone, email, or any other method.
                </p>
            </div>

            <p class="message" style="margin-top: 30px; font-size: 14px; color: #999;">
                If you didn't create an account with CoinSova, please ignore this email or contact our support team.
            </p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p style="font-weight: 600; color: #333; margin-bottom: 15px;">CoinSova - Trade Smarter, Trade Faster</p>
            <p>&copy; {{ date('Y') }} CoinSova. All rights reserved.</p>
            <p>Professional Cryptocurrency Trading Platform</p>
            
            <div class="social-links">
                <a href="#">Support</a> | 
                <a href="#">Terms</a> | 
                <a href="#">Privacy</a>
            </div>
            
            <p style="margin-top: 20px; font-size: 12px;">
                This email was sent to {{ $user->email }} because you registered on CoinSova.
            </p>
        </div>
    </div>
</body>
</html>
