import React, { useState } from "react";
import { motion } from "framer-motion";
import Navbar from "../Components/Navbar";
import { usePage } from "@inertiajs/react";

export default function ContactUs() {
    const { auth } = usePage().props;

    const [form, setForm] = useState({
        name: auth?.user?.name || "",
        email: auth?.user?.email || "",
        subject: "",
        message: "",
    });

    const handleChange = (e) => {
        setForm({ ...form, [e.target.name]: e.target.value });
    };

    const handleSubmit = (e) => {
        e.preventDefault();
        // Handle form submission via Axios or Inertia post
        console.log("Form submitted:", form);
    };

    return (
        <div className="min-h-screen bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white">
            {/* Navbar */}
            <Navbar user={auth?.user} />

            <div className="px-6 py-10 max-w-6xl mx-auto">
                {/* Header */}
                <motion.div
                    initial={{ opacity: 0, y: -20 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.6 }}
                    className="text-center mb-12"
                >
                    <h1 className="text-4xl font-bold mb-2">Contact Us</h1>
                    <p className="text-gray-600 dark:text-gray-300 text-lg">
                        We'd love to hear from you. Reach out to us anytime.
                    </p>
                </motion.div>

                {/* Contact Form and Map */}
                <div className="grid grid-cols-1 md:grid-cols-2 gap-10">
                    {/* Contact Form */}
                    <motion.form
                        initial={{ opacity: 0, x: -20 }}
                        animate={{ opacity: 1, x: 0 }}
                        transition={{ duration: 0.6 }}
                        className="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-md border border-gray-200 dark:border-gray-700"
                        onSubmit={handleSubmit}
                    >
                        <div className="mb-4">
                            <label className="block mb-1 font-medium">Name</label>
                            <input
                                type="text"
                                name="name"
                                value={form.name}
                                onChange={handleChange}
                                className="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-white"
                                required
                            />
                        </div>
                        <div className="mb-4">
                            <label className="block mb-1 font-medium">Email</label>
                            <input
                                type="email"
                                name="email"
                                value={form.email}
                                onChange={handleChange}
                                className="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-white"
                                required
                            />
                        </div>
                        <div className="mb-4">
                            <label className="block mb-1 font-medium">Subject</label>
                            <input
                                type="text"
                                name="subject"
                                value={form.subject}
                                onChange={handleChange}
                                className="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-white"
                                required
                            />
                        </div>
                        <div className="mb-4">
                            <label className="block mb-1 font-medium">Message</label>
                            <textarea
                                name="message"
                                value={form.message}
                                onChange={handleChange}
                                rows="5"
                                className="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-white"
                                required
                            />
                        </div>
                        <button
                            type="submit"
                            className="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 rounded-lg transition-colors"
                        >
                            Send Message
                        </button>
                    </motion.form>

                    {/* Google Map */}
                    <motion.div
                        initial={{ opacity: 0, x: 20 }}
                        animate={{ opacity: 1, x: 0 }}
                        transition={{ duration: 0.6 }}
                        className="rounded-xl overflow-hidden shadow-md border border-gray-200 dark:border-gray-700"
                    >
                        <iframe
                            title="San Francisco Location"
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d31560.31012601058!2d-122.4759909!3d37.7577627!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x808f7e2e522d5dfb%3A0xf5c1a7d46b81c!2sSan%20Francisco%2C%20CA!5e0!3m2!1sen!2sus!4v1700000000002"
                            width="100%"
                            height="100%"
                            style={{ minHeight: "400px", border: 0 }}
                            allowFullScreen=""
                            loading="lazy"
                            referrerPolicy="no-referrer-when-downgrade"
                        ></iframe>
                    </motion.div>
                </div>

                {/* Terms & Conditions Section */}
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.6 }}
                    className="mt-16 bg-white dark:bg-gray-800 p-8 rounded-xl shadow-md border border-gray-200 dark:border-gray-700"
                >
                    <h2 className="text-3xl font-bold mb-4 text-center">Terms & Conditions</h2>
                    <ul className="list-disc list-inside space-y-3 text-gray-700 dark:text-gray-300 leading-relaxed">
                        <li>By using Coinsova, you agree to comply with our platform rules and regulations.</li>
                        <li>All users are responsible for the security of their accounts and credentials.</li>
                        <li>Cryptocurrency trading involves risks; Coinsova is not liable for losses.</li>
                        <li>Illegal or fraudulent activity may result in account suspension or termination.</li>
                        <li>We reserve the right to update or modify these terms at any time.</li>
                        <li>These terms are governed by the applicable laws where Coinsova operates.</li>
                    </ul>
                </motion.div>

                {/* Footer */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 1 }}
                    className="text-center mt-20"
                >
                    <p className="text-gray-600 dark:text-gray-400">
                        Coinsova © {new Date().getFullYear()} — All Rights Reserved.
                    </p>
                </motion.div>
            </div>
        </div>
    );
}
