import React from "react";
import { motion } from "framer-motion";
import Navbar from "../Components/Navbar";
import { usePage } from "@inertiajs/react";

export default function AboutUs() {
    const { auth } = usePage().props;

    return (
        <div className="min-h-screen bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-white">

            {/* Navbar */}
            <Navbar user={auth?.user} />

            <div className="px-6 py-10 max-w-7xl mx-auto">

                {/* HEADER */}
                <motion.div
                    initial={{ opacity: 0, y: -20 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5 }}
                    className="text-center mb-14"
                >
                    <h1 className="text-4xl font-bold mb-3">About Coinsova</h1>
                    <p className="text-gray-600 dark:text-gray-300 text-lg">
                        Your trusted platform for secure and smart cryptocurrency trading.
                    </p>
                </motion.div>

                {/* MISSION */}
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.6 }}
                    className="max-w-4xl mx-auto mb-20"
                >
                    <h2 className="text-3xl font-semibold mb-4 text-center">Our Mission</h2>
                    <p className="text-gray-700 dark:text-gray-300 leading-relaxed text-center">
                        Coinsova brings transparency, real-time insights, and security
                        to the crypto world. Our mission is to simplify trading for everyone,
                        from beginners to experts.
                    </p>
                </motion.div>

                {/* FEATURES SECTION */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 0.8 }}
                    className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-8 max-w-6xl mx-auto"
                >
                    {[
                        { title: "Secure Trading", text: "Encrypted wallets, SSL protection & safe transactions." },
                        { title: "Real-Time Prices", text: "Live market data with millisecond updates." },
                        { title: "Lightning Fast", text: "Instant deposits & withdrawals anytime." },
                    ].map((c, i) => (
                        <motion.div
                            key={i}
                            whileHover={{ scale: 1.05 }}
                            className="p-6 bg-white dark:bg-gray-800 rounded-xl shadow-md border border-gray-200 dark:border-gray-700"
                        >
                            <h3 className="text-xl font-semibold mb-3">{c.title}</h3>
                            <p className="text-gray-700 dark:text-gray-300">{c.text}</p>
                        </motion.div>
                    ))}
                </motion.div>

                {/* TIMELINE */}
                <motion.div
                    initial={{ opacity: 0, y: 30 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.7 }}
                    className="max-w-5xl mx-auto mt-24"
                >
                    <h2 className="text-3xl font-bold text-center mb-12">Our Journey</h2>

                    <div className="relative border-l border-gray-300 dark:border-gray-700 ml-4">
                        {[
                            { year: "2021", text: "Coinsova idea drafted and core team formed." },
                            { year: "2022", text: "Platform launched with secure trading features." },
                            { year: "2023", text: "Major upgrades, live charts, new wallets added." },
                            { year: "2024", text: "Global reach achieved with 100k+ active users." },
                        ].map((event, i) => (
                            <div key={i} className="mb-10 ml-6">
                                <div className="absolute w-3 h-3 bg-blue-600 rounded-full -left-1.5 border border-white"></div>
                                <h3 className="text-xl font-semibold">{event.year}</h3>
                                <p className="text-gray-700 dark:text-gray-300">{event.text}</p>
                            </div>
                        ))}
                    </div>
                </motion.div>

                

                {/* WHY CHOOSE US */}
                <motion.div
                    initial={{ opacity: 0, y: 25 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.6 }}
                    className="max-w-6xl mx-auto mt-24"
                >
                    <h2 className="text-3xl font-bold text-center mb-12">Why Choose Coinsova?</h2>

                    <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-6">
                        {[
                            "Bank-Level Encryption",
                            "24/7 Support",
                            "Global Network",
                            "Fast Transactions",
                        ].map((item, i) => (
                            <motion.div
                                key={i}
                                whileHover={{ scale: 1.05 }}
                                className="p-6 bg-white dark:bg-gray-800 rounded-xl shadow-md border border-gray-300 dark:border-gray-700 text-center"
                            >
                                <p className="font-semibold text-lg">{item}</p>
                            </motion.div>
                        ))}
                    </div>
                </motion.div>

                {/* TERMS & CONDITIONS */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 0.7 }}
                    className="mt-24 max-w-5xl mx-auto"
                >
                    <h2 className="text-3xl font-bold mb-6">Terms & Conditions</h2>
                    <div className="p-6 bg-white dark:bg-gray-800 rounded-xl border border-gray-300 dark:border-gray-700 leading-relaxed text-gray-700 dark:text-gray-300">
                        <p>
                            By using Coinsova, you agree to follow our platform rules, trading guidelines,
                            and privacy policies. Cryptocurrencies carry financial risk; users must trade responsibly.
                        </p>
                        <p className="mt-4">
                            Coinsova reserves the right to update platform policies, security rules, and user terms.
                        </p>
                    </div>
                </motion.div>

                {/* PRIVACY POLICY */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 0.7 }}
                    className="mt-24 max-w-5xl mx-auto"
                >
                    <h2 className="text-3xl font-bold mb-6">Privacy Policy</h2>
                    <div className="p-6 bg-white dark:bg-gray-800 rounded-xl border border-gray-300 dark:border-gray-700 leading-relaxed text-gray-700 dark:text-gray-300">
                        <p>
                            We value your privacy. Coinsova never sells or shares user data with third parties.
                            Your personal information, wallet data, and trading logs remain fully protected.
                        </p>
                        <p className="mt-4">
                            We use encryption, secure APIs, and advanced firewalls to protect your identity and assets.
                        </p>
                    </div>
                </motion.div>

                {/* FAQ SECTION */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 0.6 }}
                    className="mt-24 max-w-5xl mx-auto"
                >
                    <h2 className="text-3xl font-bold mb-10 text-center">Frequently Asked Questions</h2>

                    {[ 
                        { q: "Is Coinsova safe?", a: "Yes. We use bank-level encryption and multi-layer security." },
                        { q: "How do I withdraw funds?", a: "Go to Wallet → Withdraw and follow instructions." },
                        { q: "Can I trade 24/7?", a: "Absolutely. Crypto markets never close." },
                    ].map((item, i) => (
                        <div key={i} className="mb-6">
                            <h3 className="text-xl font-semibold">{item.q}</h3>
                            <p className="text-gray-600 dark:text-gray-300">{item.a}</p>
                        </div>
                    ))}
                </motion.div>

                {/* HELP CENTER */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 0.7 }}
                    className="mt-24 max-w-5xl mx-auto"
                >
                    <h2 className="text-3xl font-bold mb-6">Help Center</h2>
                    <div className="p-6 bg-white dark:bg-gray-800 rounded-xl border border-gray-300 dark:border-gray-700 text-gray-700 dark:text-gray-300 leading-relaxed">
                        <p>Need help? Our support team is available 24/7.</p>
                        <ul className="list-disc ml-6 mt-4">
                            <li>Troubleshoot trading issues</li>
                            <li>Reset wallet or account access</li>
                            <li>Report suspicious activity</li>
                            <li>Understanding platform features</li>
                        </ul>
                    </div>
                </motion.div>

                {/* FOOTER */}
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    transition={{ duration: 1 }}
                    className="text-center mt-20 mb-10"
                >
                    <p className="text-gray-600 dark:text-gray-400">
                        Coinsova © {new Date().getFullYear()} — All Rights Reserved.
                    </p>
                </motion.div>

            </div>
        </div>
    );
}
