import React from 'react';
import { FaQuoteLeft } from 'react-icons/fa';

export default function Testimonials() {
    const reviews = [
        {
            name: "Sarah Jenkins",
            role: "Crypto Trader",
            image: "https://i.pravatar.cc/150?u=sarah",
            quote: "Coinsova has completely changed how I trade. The interface is intuitive, and the execution speed is unmatched."
        },
        {
            name: "Michael Chen",
            role: "Investor",
            image: "https://i.pravatar.cc/150?u=michael",
            quote: "Security was my top concern, and Coinsova delivers. I feel safe storing my assets here while earning great rewards."
        },
        {
            name: "David Smith",
            role: "Day Trader",
            image: "https://i.pravatar.cc/150?u=david",
            quote: "The 24/7 support is a lifesaver. Whenever I have a question, their team is there to help instantly."
        }
    ];

    return (
        <section className="py-20 bg-white dark:bg-gray-900 overflow-hidden relative">
            {/* Decorative Background */}
            <div className="absolute top-0 right-0 w-96 h-96 bg-blue-100 dark:bg-blue-900/20 rounded-full blur-3xl opacity-50 translate-x-1/2 -translate-y-1/2"></div>
            <div className="absolute bottom-0 left-0 w-96 h-96 bg-purple-100 dark:bg-purple-900/20 rounded-full blur-3xl opacity-50 -translate-x-1/2 translate-y-1/2"></div>

            <div className="container mx-auto px-6 relative z-10">
                <div className="text-center mb-16">
                    <h2 className="text-3xl md:text-5xl font-bold text-gray-900 dark:text-white mb-4">
                        Trusted by Thousands
                    </h2>
                    <p className="text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">
                        Join a growing community of happy traders who trust Coinsova for their financial journey.
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                    {reviews.map((review, idx) => (
                        <div key={idx} className="bg-gray-50 dark:bg-gray-800 p-8 rounded-2xl shadow-lg relative">
                            <FaQuoteLeft className="absolute top-6 right-6 text-4xl text-gray-200 dark:text-gray-700 opacity-50" />

                            <p className="text-gray-700 dark:text-gray-300 italic mb-6 relative z-10">
                                "{review.quote}"
                            </p>

                            <div className="flex items-center gap-4">
                                <img src={review.image} alt={review.name} className="w-12 h-12 rounded-full object-cover" />
                                <div>
                                    <h4 className="font-bold text-gray-900 dark:text-white">{review.name}</h4>
                                    <span className="text-xs text-blue-500 uppercase tracking-wider font-semibold">{review.role}</span>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
