import React from 'react';

export default function Stats() {
    const stats = [
        { label: "Quarterly Volume", value: "$52B+" },
        { label: "Verified Users", value: "2M+" },
        { label: "Countries Supported", value: "100+" },
        { label: "Verified Transactions", value: "150M+" }
    ];

    return (
        <section className="py-20 bg-blue-600 dark:bg-blue-900 relative overflow-hidden">
            {/* Background Pattern */}
            <div className="absolute inset-0 opacity-10"
                style={{ backgroundImage: 'radial-gradient(circle, #fff 1px, transparent 1px)', backgroundSize: '30px 30px' }}>
            </div>

            <div className="container mx-auto px-6 relative z-10">
                <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center divide-x divide-blue-500/30">
                    {stats.map((stat, idx) => (
                        <div key={idx} className="p-4">
                            <div className="text-4xl md:text-5xl font-extrabold text-white mb-2 tracking-tight">
                                {stat.value}
                            </div>
                            <div className="text-blue-100 font-medium text-lg uppercase tracking-wide opacity-80">
                                {stat.label}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
