import React from 'react';

export default function MarketTicker({ coins = [] }) {
    // Duplicate list for seamless infinite scroll
    const marqueeItems = [...coins, ...coins, ...coins];

    return (
        <div className="w-full bg-white dark:bg-gray-900 border-y border-gray-100 dark:border-gray-800 py-3 overflow-hidden relative z-20 shadow-sm">
            <div className="marquee-container flex items-center">
                <div className="animate-marquee flex items-center gap-12 whitespace-nowrap">
                    {marqueeItems.map((coin, index) => (
                        <div key={`${coin.id}-${index}`} className="flex items-center gap-3 group cursor-pointer hover:scale-105 transition-transform">
                            <img src={coin.image} alt={coin.name} className="w-6 h-6 rounded-full transition-all duration-300" />
                            <div className="flex flex-col leading-none">
                                <span className="font-bold text-sm text-gray-700 dark:text-gray-200">{coin.symbol.toUpperCase()}</span>
                                <div className="flex items-center gap-2 text-xs">
                                    <span className="font-mono text-gray-600 dark:text-gray-400">${coin.current_price.toLocaleString()}</span>
                                    <span className={coin.price_change_percentage_24h >= 0 ? 'text-green-500' : 'text-red-500'}>
                                        {coin.price_change_percentage_24h > 0 ? '▲' : '▼'} {Math.abs(coin.price_change_percentage_24h).toFixed(2)}%
                                    </span>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>

            <style>{`
                .animate-marquee {
                    animation: marquee 80s linear infinite;
                }
                .animate-marquee:hover {
                    animation-play-state: paused;
                }
                @keyframes marquee {
                    0% { transform: translateX(0); }
                    100% { transform: translateX(-50%); }
                }
            `}</style>
        </div>
    );
}
