import React from 'react';
import { FaUserPlus, FaWallet, FaRocket } from 'react-icons/fa';

export default function HowItWorks() {
    const steps = [
        {
            icon: <FaUserPlus className="w-8 h-8 text-white" />,
            title: "Create Account",
            desc: "Sign up in seconds. Verify your identity to unlock full features.",
            color: "bg-blue-600",
            shadow: "shadow-blue-500/30"
        },
        {
            icon: <FaWallet className="w-8 h-8 text-white" />,
            title: "Deposit Funds",
            desc: "Add crypto or fiat to your secure wallet with zero hidden fees.",
            color: "bg-purple-600",
            shadow: "shadow-purple-500/30"
        },
        {
            icon: <FaRocket className="w-8 h-8 text-white" />,
            title: "Start Trading",
            desc: "Buy, sell, and trade over 200+ cryptocurrencies instantly.",
            color: "bg-pink-600",
            shadow: "shadow-pink-500/30"
        }
    ];

    return (
        <section className="py-24 bg-white dark:bg-gray-900 border-t border-gray-100 dark:border-gray-800">
            <div className="container mx-auto px-6">
                <div className="text-center mb-16">
                    <h2 className="text-3xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                        Start Trading in 3 Easy Steps
                    </h2>
                    <p className="text-gray-600 dark:text-gray-400 max-w-2xl mx-auto text-lg">
                        Get started with Coinsova today and join the world's most secure crypto exchange.
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-3 gap-12 relative">
                    {/* Connecting Line (Desktop) */}
                    <div className="hidden md:block absolute top-12 left-[16%] right-[16%] h-1 bg-gray-100 dark:bg-gray-800 z-0"></div>

                    {steps.map((step, idx) => (
                        <div key={idx} className="relative z-10 flex flex-col items-center text-center">
                            <div className={`w-24 h-24 rounded-3xl ${step.color} ${step.shadow} shadow-xl flex items-center justify-center mb-8 transform hover:scale-110 transition-transform duration-300`}>
                                {step.icon}
                            </div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {step.title}
                            </h3>
                            <p className="text-gray-600 dark:text-gray-400 leading-relaxed px-4">
                                {step.desc}
                            </p>

                            {/* Step Number Badge */}
                            <div className="absolute top-0 right-[25%] -mt-2 -mr-2 w-8 h-8 rounded-full bg-white dark:bg-gray-800 border-4 border-gray-50 dark:border-gray-900 flex items-center justify-center font-bold text-gray-400 text-sm shadow-sm">
                                {idx + 1}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
