import React from 'react';
import { FaTwitter, FaFacebook, FaDiscord, FaTelegram } from 'react-icons/fa';

export default function HomeFooter() {
    return (
        <footer className="bg-gray-100 dark:bg-gray-950 text-gray-600 dark:text-gray-400 border-t border-gray-200 dark:border-gray-900 pt-16 pb-8">
            <div className="container mx-auto px-6">
                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
                    {/* Brand Column */}
                    <div>
                        <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">Coinsova</h2>
                        <p className="mb-6 leading-relaxed text-sm">
                            The world's most trusted and secure crypto exchange. Buy, sell, and trade over 200 cryptocurrencies with ease and confidence.
                        </p>
                    </div>

                    {/* Links */}
                    <div>
                        <h3 className="text-gray-900 dark:text-white font-bold mb-4">Company</h3>
                        <ul className="space-y-3 text-sm">
                            <li><a href="/about-us" className="hover:text-blue-500 transition-colors">About Us</a></li>
                            <li><a href="/contact-us" className="hover:text-blue-500 transition-colors">Contact Us</a></li>
                        </ul>
                    </div>

                    <div>
                        <h3 className="text-gray-900 dark:text-white font-bold mb-4">Support</h3>
                        <ul className="space-y-3 text-sm">
                            <li><a href="/about-us" className="hover:text-blue-500 transition-colors">Help Center</a></li>
                            <li><a href="/about-us" className="hover:text-blue-500 transition-colors">Trading Fees</a></li>
                            <li><a href="/contact-us" className="hover:text-blue-500 transition-colors">Support Center</a></li>
                        </ul>
                    </div>

                    {/* Products Column */}
                    <div>
                        <h3 className="text-gray-900 dark:text-white font-bold mb-4">Products</h3>
                        <ul className="space-y-3 text-sm">
                            <li><a href="/user-dashboard" className="hover:text-blue-500 transition-colors">Spot Trading</a></li>
                            <li><a href="/user-dashboard" className="hover:text-blue-500 transition-colors">Futures Trading</a></li>
                            <li><a href="/wallet" className="hover:text-blue-500 transition-colors">Buy Crypto</a></li>
                            <li><a href="/wallet" className="hover:text-blue-500 transition-colors">Crypto Wallet</a></li>
                        </ul>
                    </div>
                </div>

                <div className="pt-8 border-t border-gray-200 dark:border-gray-900 flex flex-col md:flex-row justify-between items-center gap-4 text-sm">
                    <p>© {new Date().getFullYear()} Coinsova. All rights reserved.</p>
                    <div className="flex gap-6">
                        <a href="/about-us" className="hover:text-blue-500 transition-colors">Privacy Policy</a>
                        <a href="/about-us" className="hover:text-blue-500 transition-colors">Terms of Service</a>
                    </div>
                </div>
            </div>
        </footer>
    );
}
