import React from 'react';
import { Link } from '@inertiajs/react';

export default function Hero({ user, topCoins = [] }) {
    return (
        <section className="relative w-full min-h-[90vh] flex items-center justify-center overflow-hidden bg-white dark:bg-gray-900 transition-colors duration-500">
            {/* Background Gradient Orbs */}
            <div className="absolute top-0 left-0 w-full h-full overflow-hidden z-0">
                <div className="absolute top-[-10%] left-[-10%] w-[50%] h-[50%] rounded-full bg-purple-500/20 blur-[120px] animate-pulse-slow"></div>
                <div className="absolute bottom-[-10%] right-[-10%] w-[50%] h-[50%] rounded-full bg-blue-500/20 blur-[120px] animate-pulse-slow delay-1000"></div>
                <div className="absolute top-[20%] right-[20%] w-[30%] h-[30%] rounded-full bg-yellow-400/10 blur-[100px] animate-float"></div>
            </div>

            {/* Grid Pattern Overlay */}
            <div className="absolute inset-0 z-0 opacity-[0.03] dark:opacity-[0.05]"
                style={{ backgroundImage: 'radial-gradient(circle, #888 1px, transparent 1px)', backgroundSize: '40px 40px' }}>
            </div>

            <div className="container relative z-10 mx-auto px-6 grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                {/* Text Content */}
                <div className="space-y-8 text-center lg:text-left">
                    <div className="inline-block px-4 py-1 rounded-full bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 font-semibold text-sm tracking-wider uppercase mb-2 border border-blue-200 dark:border-blue-800">
                        Top Rated Crypto Exchange
                    </div>

                    <h1 className="text-5xl md:text-7xl font-extrabold leading-tight tracking-tight text-gray-900 dark:text-white">
                        Trade the <br />
                        <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 dark:from-blue-400 dark:via-purple-400 dark:to-indigo-400">
                            Future of Money
                        </span>
                    </h1>

                    <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto lg:mx-0 leading-relaxed">
                        Experience lightning-fast transactions, institutional-grade security, and 24/7 support. Join millions of users trading globally on Coinsova.
                    </p>

                    <div className="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                        {!user ? (
                            <>
                                <Link
                                    href="/register"
                                    className="px-8 py-4 bg-blue-600 hover:bg-blue-700 text-white font-bold rounded-xl shadow-lg shadow-blue-500/30 transform hover:scale-[1.02] transition-all"
                                >
                                    Start Trading Now
                                </Link>
                                <Link
                                    href="/login"
                                    className="px-8 py-4 bg-white dark:bg-gray-800 text-gray-800 dark:text-white font-bold rounded-xl shadow-md border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700 transition-all"
                                >
                                    Login
                                </Link>
                            </>
                        ) : (
                            <Link
                                href="/wallet"
                                className="px-8 py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold rounded-xl shadow-lg transform hover:scale-[1.02] transition-all"
                            >
                                Go to Dashboard
                            </Link>
                        )}
                    </div>

                    <div className="pt-8 flex items-center justify-center lg:justify-start gap-8 text-gray-500 dark:text-gray-400 text-sm font-medium">
                        <div className="flex items-center gap-2">
                            <span className="w-2 h-2 rounded-full bg-green-500"></span> 24/7 Support
                        </div>
                        <div className="flex items-center gap-2">
                            <span className="w-2 h-2 rounded-full bg-green-500"></span> Secure Wallets
                        </div>
                        <div className="flex items-center gap-2">
                            <span className="w-2 h-2 rounded-full bg-green-500"></span> Low Fees
                        </div>
                    </div>
                </div>

                {/* Hero Visuals / 3D Composition */}
                <div className="relative hidden lg:block h-[600px] w-full">
                    {/* Levitating Cards */}
                    <div className="absolute top-[10%] left-[10%] w-64 h-80 bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-2xl p-6 border border-white/50 dark:border-gray-700 z-20 animate-float-y">
                        <div className="flex items-center justify-between mb-4">
                            <h3 className="font-bold text-gray-800 dark:text-white">Bitcoin</h3>
                            <span className="bg-orange-100 text-orange-600 text-xs font-bold px-2 py-1 rounded">BTC</span>
                        </div>
                        <div className="h-24 bg-gradient-to-b from-orange-500/10 to-transparent rounded-lg mb-4 flex items-end p-2 relative overflow-hidden">
                            {/* Mock Chart Line */}
                            <svg viewBox="0 0 100 40" className="w-full h-full stroke-orange-500 fill-none stroke-2 overflow-visible">
                                <path d="M0 30 C 20 20, 40 35, 60 15 S 80 5, 100 0" />
                            </svg>
                        </div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">$98,450</div>
                        <div className="text-green-500 text-sm font-semibold">+5.4%</div>
                    </div>

                    <div className="absolute top-[40%] right-[10%] w-64 h-80 bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-2xl p-6 border border-white/50 dark:border-gray-700 z-10 animate-float-y-reverse delay-1000">
                        <div className="flex items-center justify-between mb-4">
                            <h3 className="font-bold text-gray-800 dark:text-white">Ethereum</h3>
                            <span className="bg-blue-100 text-blue-600 text-xs font-bold px-2 py-1 rounded">ETH</span>
                        </div>
                        <div className="h-24 bg-gradient-to-b from-blue-500/10 to-transparent rounded-lg mb-4 flex items-end p-2 relative overflow-hidden">
                            {/* Mock Chart Line */}
                            <svg viewBox="0 0 100 40" className="w-full h-full stroke-blue-500 fill-none stroke-2 overflow-visible">
                                <path d="M0 25 C 10 35, 30 15, 50 25 S 80 10, 100 5" />
                            </svg>
                        </div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">$4,820</div>
                        <div className="text-green-500 text-sm font-semibold">+3.2%</div>
                    </div>

                    {/* Decorative Elements */}
                    <div className="absolute top-[30%] left-[40%] w-20 h-20 bg-purple-500 rounded-2xl rotate-12 blur-xl opacity-60 animate-pulse"></div>
                    <div className="absolute bottom-[20%] right-[30%] w-32 h-32 bg-blue-500 rounded-full blur-2xl opacity-40 animate-pulse delay-500"></div>
                </div>
            </div>

            <style>{`
                @keyframes float-y {
                    0%, 100% { transform: translateY(0px); }
                    50% { transform: translateY(-20px); }
                }
                @keyframes float-y-reverse {
                     0%, 100% { transform: translateY(0px); }
                     50% { transform: translateY(20px); }
                }
                @keyframes pulse-slow {
                    0%, 100% { opacity: 0.3; transform: scale(1); }
                    50% { opacity: 0.6; transform: scale(1.1); }
                }
                .animate-float-y { animation: float-y 6s ease-in-out infinite; }
                .animate-float-y-reverse { animation: float-y-reverse 7s ease-in-out infinite; }
                .animate-pulse-slow { animation: pulse-slow 10s ease-in-out infinite; }
            `}</style>
        </section>
    );
}
