import React from 'react';
import { FaShieldAlt, FaChartLine, FaBolt, FaHeadset } from 'react-icons/fa';

export default function Features() {

    const features = [
        {
            icon: <FaChartLine className="w-8 h-8 text-blue-500" />,
            title: "Real-Time Trading",
            desc: "Execute trades instantly with our high-frequency matching engine. Never miss a market movement."
        },
        {
            icon: <FaShieldAlt className="w-8 h-8 text-green-500" />,
            title: "Bank-Grade Security",
            desc: "Your assets are protected by cold storage, multi-sig wallets, and advanced encryption protocols."
        },
        {
            icon: <FaBolt className="w-8 h-8 text-yellow-500" />,
            title: "Fast Execution",
            desc: "Experience zero latency and instant order fills, even during periods of high market volatility."
        },
        {
            icon: <FaHeadset className="w-8 h-8 text-purple-500" />,
            title: "24/7 Expert Support",
            desc: "Our dedicated support team is available round-the-clock to assist you with any questions."
        }
    ];

    return (
        <section className="py-20 bg-gray-50 dark:bg-gray-900 transition-colors duration-500">
            <div className="container mx-auto px-6">
                <div className="text-center max-w-3xl mx-auto mb-16">
                    <h2 className="text-3xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                        Why Choose Coinsova?
                    </h2>
                    <p className="text-lg text-gray-600 dark:text-gray-400">
                        We build tools for the crypto-native. Whether you're a beginner or a pro, we have the features you need.
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    {features.map((feature, idx) => (
                        <div key={idx} className="group p-8 rounded-2xl bg-white dark:bg-gray-800 shadow-xl hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-gray-100 dark:border-gray-700">
                            <div className="w-16 h-16 rounded-2xl bg-gray-50 dark:bg-gray-700/50 flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                                {feature.icon}
                            </div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {feature.title}
                            </h3>
                            <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                                {feature.desc}
                            </p>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
