import React from 'react';
import { FaApple, FaGooglePlay } from 'react-icons/fa';

export default function AppSection() {
    return (
        <section className="py-24 bg-gray-50 dark:bg-gray-900 overflow-hidden">
            <div className="container mx-auto px-6">
                <div className="bg-gray-900 dark:bg-black rounded-[3rem] p-8 md:p-16 relative overflow-hidden shadow-2xl">
                    {/* Glow Effects */}
                    <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-blue-500/20 rounded-full blur-[100px] translate-x-1/3 -translate-y-1/3"></div>
                    <div className="absolute bottom-0 left-0 w-[500px] h-[500px] bg-purple-500/20 rounded-full blur-[100px] -translate-x-1/3 translate-y-1/3"></div>

                    <div className="flex flex-col lg:flex-row items-center gap-16 relative z-10">
                        <div className="flex-1 text-center lg:text-left space-y-8">
                            <h2 className="text-4xl md:text-5xl font-bold text-white leading-tight">
                                Trade Anytime, <br />
                                <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-400">Anywhere.</span>
                            </h2>
                            <p className="text-gray-400 text-lg max-w-xl mx-auto lg:mx-0">
                                Download the Coinsova app to manage your portfolio, track prices, and trade crypto on the go. Available for iOS and Android.
                            </p>

                            <div className="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                                <button className="flex items-center justify-center gap-3 px-6 py-3 bg-white text-gray-900 rounded-xl hover:bg-gray-100 transition-colors font-bold shadow-lg">
                                    <FaApple className="text-2xl" />
                                    <div className="text-left leading-tight">
                                        <div className="text-xs text-gray-500 font-medium">Download on the</div>
                                        <div className="text-sm">App Store</div>
                                    </div>
                                </button>
                                <button className="flex items-center justify-center gap-3 px-6 py-3 bg-white text-gray-900 rounded-xl hover:bg-gray-100 transition-colors font-bold shadow-lg">
                                    <FaGooglePlay className="text-xl text-green-600" />
                                    <div className="text-left leading-tight">
                                        <div className="text-xs text-gray-500 font-medium">GET IT ON</div>
                                        <div className="text-sm">Google Play</div>
                                    </div>
                                </button>
                            </div>
                        </div>

                        {/* Phone Mockup Placeholder */}
                        <div className="flex-1 relative flex justify-center">
                            <div className="relative w-[300px] h-[600px] bg-gray-800 rounded-[3rem] border-8 border-gray-700 shadow-2xl flex items-center justify-center overflow-hidden">
                                <div className="absolute inset-0 bg-gradient-to-b from-gray-800 to-black"></div>
                                {/* Mock App Screen */}
                                <div className="absolute inset-2 bg-gray-900 rounded-[2.5rem] overflow-hidden flex flex-col">
                                    <div className="h-1/2 bg-gradient-to-b from-blue-600 to-purple-900 p-6 text-white text-center pt-12">
                                        <div className="text-sm opacity-70 mb-1">Total Balance</div>
                                        <div className="text-3xl font-bold mb-8">$24,500.00</div>
                                        <div className="flex justify-around">
                                            <div className="w-10 h-10 rounded-full bg-white/20"></div>
                                            <div className="w-10 h-10 rounded-full bg-white/20"></div>
                                            <div className="w-10 h-10 rounded-full bg-white/20"></div>
                                            <div className="w-10 h-10 rounded-full bg-white/20"></div>
                                        </div>
                                    </div>
                                    <div className="h-1/2 bg-gray-900 p-4 space-y-4">
                                        {[1, 2, 3].map(i => (
                                            <div key={i} className="h-12 w-full bg-gray-800 rounded-lg animate-pulse"></div>
                                        ))}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}
