<?php

use App\Models\User;
use App\Models\WalletTransaction;
use Illuminate\Support\Facades\Log;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Clean up test user if exists
User::where('email', 'testverify@example.com')->delete();

// Create User
$user = User::create([
    'name' => 'Test Verify',
    'email' => 'testverify@example.com',
    'password' => bcrypt('password'),
]);

echo "Created User ID: " . $user->id . "\n";

// 1. Initial Balance
echo "Initial Balance: " . $user->getAvailableBalance('USDT') . "\n";

// 2. Add Deposit (1000 USDT)
WalletTransaction::create([
    'user_id' => $user->id,
    'crypto' => 'USDT',
    'amount' => 1000,
    'type' => 'deposit',
    'status' => 'approved',
    'source' => 'user'
]);

echo "After Deposit (1000): " . $user->getAvailableBalance('USDT') . "\n";

// 3. Request Withdrawal (100 USDT)
$wd = WalletTransaction::create([
    'user_id' => $user->id,
    'crypto' => 'USDT',
    'amount' => 100,
    'type' => 'withdraw',
    'status' => 'pending',
    'source' => 'user'
]);

echo "After Pending Withdrawal (100): " . $user->getAvailableBalance('USDT') . "\n";

// 4. Approve Withdrawal
$wd->status = 'approved';
$wd->save();

echo "After Approved Withdrawal (100): " . $user->getAvailableBalance('USDT') . "\n";

// Cleanup
$user->walletTransactions()->delete();
$user->delete();
