export interface CountdownTimeDeltaOptions {
    readonly now?: () => number;
    readonly precision?: number;
    readonly controlled?: boolean;
    readonly offsetTime?: number;
    readonly overtime?: boolean;
}
export interface CountdownTimeDelta {
    readonly total: number;
    readonly days: number;
    readonly hours: number;
    readonly minutes: number;
    readonly seconds: number;
    readonly milliseconds: number;
    readonly completed: boolean;
}
export interface CountdownTimeDeltaFormatted {
    readonly days: string;
    readonly hours: string;
    readonly minutes: string;
    readonly seconds: string;
}
export interface CountdownTimeDeltaFormatOptions {
    readonly daysInHours?: boolean;
    readonly zeroPadTime?: number;
    readonly zeroPadDays?: number;
}
export declare function zeroPad(value: number | string, length?: number): string;
export declare const timeDeltaFormatOptionsDefaults: CountdownTimeDeltaFormatOptions;
export declare function calcTimeDelta(date: Date | string | number, options?: CountdownTimeDeltaOptions): CountdownTimeDelta;
export declare function formatTimeDelta(timeDelta: CountdownTimeDelta, options?: CountdownTimeDeltaFormatOptions): CountdownTimeDeltaFormatted;
