import * as React from 'react';
import * as PropTypes from 'prop-types';
export interface CountdownProps {
    readonly count?: number;
    readonly children?: React.ReactElement<any>;
    readonly onComplete?: () => void;
}
interface CountdownState {
    readonly count: number;
}
export default class Countdown extends React.Component<CountdownProps, CountdownState> {
    static propTypes: {
        count: PropTypes.Requireable<number>;
        children: PropTypes.Requireable<PropTypes.ReactElementLike>;
        onComplete: PropTypes.Requireable<(...args: any[]) => any>;
    };
    state: CountdownState;
    interval: number | undefined;
    componentDidMount(): void;
    componentWillUnmount(): void;
    startCountdown: () => void;
    stopCountdown: () => void;
    addTime: (seconds: number) => void;
    render(): React.ReactNode;
}
export {};
