import * as React from 'react';
import * as PropTypes from 'prop-types';
import LegacyCountdown, { CountdownProps as LegacyCountdownProps } from './LegacyCountdown';
import { CountdownTimeDelta, CountdownTimeDeltaFormatted, CountdownTimeDeltaFormatOptions } from './utils';
interface Props<T> {
    children?: React.ReactNode | undefined;
    key?: React.Key | undefined;
    ref?: React.LegacyRef<T> | undefined;
}
export interface CountdownProps extends Props<Countdown>, CountdownTimeDeltaFormatOptions, Omit<LegacyCountdownProps, 'onComplete'> {
    readonly date: Date | number | string;
    readonly controlled?: boolean;
    readonly intervalDelay?: number;
    readonly precision?: number;
    readonly autoStart?: boolean;
    readonly overtime?: boolean;
    readonly className?: string;
    readonly children?: React.ReactElement<any>;
    readonly renderer?: CountdownRendererFn;
    readonly now?: () => number;
    readonly onMount?: CountdownTimeDeltaFn;
    readonly onStart?: CountdownTimeDeltaFn;
    readonly onPause?: CountdownTimeDeltaFn;
    readonly onStop?: CountdownTimeDeltaFn;
    readonly onTick?: CountdownTimeDeltaFn;
    readonly onComplete?: ((timeDelta: CountdownTimeDelta, completedOnStart: boolean) => void) | LegacyCountdownProps['onComplete'];
}
export interface CountdownRenderProps extends CountdownTimeDelta {
    readonly api: CountdownApi;
    readonly props: CountdownProps;
    readonly formatted: CountdownTimeDeltaFormatted;
}
export declare type CountdownRendererFn = (props: CountdownRenderProps) => React.ReactNode;
export declare type CountdownTimeDeltaFn = (timeDelta: CountdownTimeDelta) => void;
declare const enum CountdownStatus {
    STARTED = "STARTED",
    PAUSED = "PAUSED",
    STOPPED = "STOPPED",
    COMPLETED = "COMPLETED"
}
interface CountdownState {
    readonly timeDelta: CountdownTimeDelta;
    readonly status: CountdownStatus;
}
export interface CountdownApi {
    readonly start: () => void;
    readonly pause: () => void;
    readonly stop: () => void;
    readonly isStarted: () => boolean;
    readonly isPaused: () => boolean;
    readonly isStopped: () => boolean;
    readonly isCompleted: () => boolean;
}
export default class Countdown extends React.Component<CountdownProps, CountdownState> {
    static defaultProps: Partial<CountdownProps>;
    static propTypes: {
        date: PropTypes.Requireable<string | number | Date>;
        daysInHours: PropTypes.Requireable<boolean>;
        zeroPadTime: PropTypes.Requireable<number>;
        zeroPadDays: PropTypes.Requireable<number>;
        controlled: PropTypes.Requireable<boolean>;
        intervalDelay: PropTypes.Requireable<number>;
        precision: PropTypes.Requireable<number>;
        autoStart: PropTypes.Requireable<boolean>;
        overtime: PropTypes.Requireable<boolean>;
        className: PropTypes.Requireable<string>;
        children: PropTypes.Requireable<PropTypes.ReactElementLike>;
        renderer: PropTypes.Requireable<(...args: any[]) => any>;
        now: PropTypes.Requireable<(...args: any[]) => any>;
        onMount: PropTypes.Requireable<(...args: any[]) => any>;
        onStart: PropTypes.Requireable<(...args: any[]) => any>;
        onPause: PropTypes.Requireable<(...args: any[]) => any>;
        onStop: PropTypes.Requireable<(...args: any[]) => any>;
        onTick: PropTypes.Requireable<(...args: any[]) => any>;
        onComplete: PropTypes.Requireable<(...args: any[]) => any>;
    };
    mounted: boolean;
    interval: number | undefined;
    api: CountdownApi | undefined;
    initialTimestamp: number;
    offsetStartTimestamp: number;
    offsetTime: number;
    legacyMode: boolean;
    legacyCountdownRef: LegacyCountdown | null;
    constructor(props: CountdownProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: CountdownProps): void;
    componentWillUnmount(): void;
    tick: () => void;
    calcTimeDelta(): CountdownTimeDelta;
    calcOffsetStartTimestamp(): number;
    setLegacyCountdownRef: (ref: LegacyCountdown | null) => void;
    start: () => void;
    pause: () => void;
    stop: () => void;
    addTime(seconds: number): void;
    clearTimer(): void;
    isStarted: () => boolean;
    isPaused: () => boolean;
    isStopped: () => boolean;
    isCompleted: () => boolean;
    isStatus(status: CountdownStatus): boolean;
    setTimeDeltaState(timeDelta: CountdownTimeDelta, status?: CountdownStatus, callback?: (timeDelta: CountdownTimeDelta) => void): void;
    getApi(): CountdownApi;
    getRenderProps(): CountdownRenderProps;
    render(): React.ReactNode;
}
export {};
