<?php

use App\Models\User;
use Illuminate\Support\Facades\Log;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$user = User::first();
if ($user) {
    echo "Checking balance for user: " . $user->email . "\n";
    $cryptos = ['btc', 'eth', 'sol', 'bnb', 'xrp', 'ada', 'doge', 'trx', 'link', 'dot', 'matic', 'ltc', 'avax', 'atom', 'etc', 'usdt', 'usdc'];
    foreach ($cryptos as $crypto) {
        $bal = $user->getAvailableBalance($crypto);
        if ($bal > 0) {
            echo "Balance ($crypto): " . $bal . "\n";
        }
    }
} else {
    echo "No user found.\n";
}
