<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('trades', function (Blueprint $table) {
            $table->string('crypto')->nullable()->after('user_id');
        });
        
        // Copy asset value to crypto for existing records
        DB::statement('UPDATE trades SET crypto = asset WHERE crypto IS NULL');
    }

    public function down(): void
    {
        Schema::table('trades', function (Blueprint $table) {
            $table->dropColumn('crypto');
        });
    }
};
