<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('trades', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('asset'); // BTC/USDT, ETH/USDT, etc.
            $table->decimal('amount', 20, 8); // USD amount invested
            $table->enum('direction', ['buy', 'sell']);
            $table->decimal('leverage', 8, 2)->default(1); // leverage used
            $table->enum('status', ['pending', 'approved', 'declined'])->default('pending');
            $table->decimal('profit', 20, 8)->nullable();
            $table->timestamp('expiry_at')->nullable(); // trade expiry time
            $table->decimal('purchase_price', 20, 8)->nullable();
            $table->decimal('delivery_price', 20, 8)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trades');
    }
};
