<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('wallet_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('crypto'); // BTC, ETH, SOL, etc.
            $table->decimal('amount', 20, 8);
            $table->enum('type', ['deposit', 'withdraw']);
            $table->enum('status', ['pending', 'approved', 'declined'])->default('pending');
            $table->string('proof')->nullable(); // file path
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wallet_transactions');
    }
};
