<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    if (!Schema::hasTable('x_debug_marker_app')) {
        Schema::create('x_debug_marker_app', function($t) { 
            $t->id(); 
            $t->string('msg'); 
            $t->timestamps();
        });
        DB::table('x_debug_marker_app')->insert([
            'msg' => 'I AM THE REAL DB',
            'created_at' => now()
        ]);
        echo "✅ Created marker table 'x_debug_marker_app' in " . config('database.connections.mysql.database') . "\n";
    } else {
        echo "ℹ️ Marker table already exists\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
