<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== TESTING LOCALHOST CONNECTION ===\n";

try {
    // Force connection to localhost
    Config::set('database.connections.mysql.host', 'localhost');
    DB::purge('mysql');
    DB::reconnect('mysql');
    
    $pdo = DB::connection()->getPdo();
    $serverInfo = DB::select('SELECT @@hostname as host, @@port as port, @@datadir as datadir, @@version as version')[0];
    
    echo "Connected to: localhost\n";
    echo "Server Host: " . $serverInfo->host . "\n";
    echo "Server DataDir: " . $serverInfo->datadir . "\n";
    
    $count = DB::table('wallet_transactions')->count();
    echo "Transaction Count: $count\n";
    
} catch (\Exception $e) {
    echo "Error connecting to localhost: " . $e->getMessage() . "\n";
}
