<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== LARAVEL CONNECTION INFO ===\n";
echo "Config Database: " . config('database.connections.mysql.database') . "\n";
echo "Config Host: " . config('database.connections.mysql.host') . "\n";
echo "Config Port: " . config('database.connections.mysql.port') . "\n";

try {
    $pdo = DB::connection()->getPdo();
    
    echo "\n=== MYSQL SERVER INFO ===\n";
    $results = DB::select('SELECT @@hostname as host, @@port as port, @@datadir as datadir, @@version as version');
    foreach ($results[0] as $key => $value) {
        echo "Server $key: $value\n";
    }

    echo "\n=== DATA CHECK ===\n";
    $count = \App\Models\WalletTransaction::count();
    echo "Total Transactions in DB: " . $count . "\n";
    
    if ($count > 0) {
        $latest = \App\Models\WalletTransaction::latest()->first();
        echo "Latest Transaction ID: " . $latest->id . "\n";
        echo "Latest Created At: " . $latest->created_at . "\n";
    }

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
