<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Active Database: " . config('database.connections.mysql.database') . "\n";
echo "Active Host: " . config('database.connections.mysql.host') . "\n";

try {
    $count = \App\Models\WalletTransaction::count();
    echo "Total Transactions: " . $count . "\n";
    
    $latest = \App\Models\WalletTransaction::latest()->take(5)->get();
    echo "Latest 5 Transactions:\n";
    foreach ($latest as $t) {
        echo "ID: {$t->id} | Amount: {$t->amount} | Status: {$t->status} | Created: {$t->created_at}\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
