<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

$dbs = ['tradecoin', 'coineuqr_Basitalikhan12'];

echo "=== CHECKING DATABASES ===\n";

foreach ($dbs as $dbName) {
    echo "\nChecking Database: $dbName\n";
    try {
        // Switch connection to this DB
        Config::set('database.connections.mysql.database', $dbName);
        DB::purge('mysql');
        DB::reconnect('mysql');
        
        $count = DB::table('wallet_transactions')->count();
        echo "Transaction Count: $count\n";
        
        if ($count > 0) {
            $latest = DB::table('wallet_transactions')->latest()->first();
            echo "Latest ID: " . $latest->id . "\n";
            echo "Latest Amount: " . $latest->amount . "\n";
            echo "Latest Created: " . $latest->created_at . "\n";
        }
    } catch (\Exception $e) {
        echo "Error: " . $e->getMessage() . "\n";
    }
}
