<?php

use App\Models\User;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$users = User::all();
$cryptos = ['btc', 'eth', 'sol', 'bnb', 'xrp', 'ada', 'doge', 'trx', 'link', 'dot', 'matic', 'ltc', 'avax', 'atom', 'etc', 'usdt', 'usdc'];
$rates = [
    'BTC' => 65000,
    'ETH' => 3500,
    'SOL' => 150,
    'XRP' => 0.6,
    'DOGE' => 0.15,
    'USDT' => 1,
    'USDC' => 1,
];

foreach ($users as $user) {
    echo "User ID: {$user->id} ({$user->email})\n";
    $totalUsd = 0;
    foreach ($cryptos as $crypto) {
        $bal = $user->getAvailableBalance($crypto);
        if ($bal > 0) {
            echo "  - {$crypto}: {$bal}\n";
            $rate = $rates[strtoupper($crypto)] ?? 0;
            $totalUsd += $bal * $rate;
        }
    }
    echo "  >> Total USD: {$totalUsd}\n\n";
}
