#!/usr/bin/env php
<?php
// Quick script to approve all pending wallet transactions
// Run: php approve_pending_deposits.php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Approving all pending wallet transactions...\n\n";

$count = DB::table('wallet_transactions')
    ->where('status', 'pending')
    ->update([
        'status' => 'approved',
        'updated_at' => now()
    ]);

echo "✅ Approved {$count} pending transactions!\n";
echo "\nNow reload your wallet page to see them.\n";
