<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'plain_password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $appends = ['kyc_status'];
public function walletTransactions()
{
    return $this->hasMany(WalletTransaction::class);
}

    public function chat()
    {
        return $this->hasOne(Chat::class);
    }

    public function kycVerification()
    {
        return $this->hasOne(KycVerification::class)->latest();
    }

    public function getKycStatusAttribute()
    {
        return $this->kycVerification?->status ?? 'unverified';
    }

    public function trades()
    {
        return $this->hasMany(Trade::class);
    }

    /**
     * Get available balance for a specific crypto.
     * Calculated as: (Approved Deposits - Approved Withdrawals) - (Pending Withdrawals) - (Active Trade Amounts)
     */
    public function getAvailableBalance($crypto)
    {
        $crypto = strtoupper($crypto);

        // 1. Total Approved Deposits
        $deposits = $this->walletTransactions()
            ->where('crypto', $crypto)
            ->where('status', 'approved')
            ->where('type', 'deposit')
            ->sum('amount');

        // 2. Total Approved Withdrawals
        $withdrawals = $this->walletTransactions()
            ->where('crypto', $crypto)
            ->where('status', 'approved')
            ->where('type', 'withdraw')
            ->sum('amount');

        // 3. Pending Withdrawals (Locked Funds)
        $pendingWithdrawals = $this->walletTransactions()
            ->where('crypto', $crypto)
            ->where('status', 'pending')
            ->where('type', 'withdraw')
            ->sum('amount');

        // 4. Active Trade Amounts (Locked Funds)
        // Only count trades that haven't been settled yet (delivery_price is null)
        $activeTrades = $this->trades()
            ->where('crypto', $crypto)
            ->whereIn('status', ['pending', 'approved']) // Running trades
            ->whereNull('delivery_price') // MUST exclude settled trades
            ->sum('amount');

        $totalBalance = $deposits - $withdrawals;
        $availableBalance = $totalBalance - $pendingWithdrawals - $activeTrades;

        \Log::info("Balance Check for User {$this->id} ({$crypto})", [
            'deposits (approved)' => $deposits,
            'withdrawals (approved)' => $withdrawals,
            'pending_withdrawals' => $pendingWithdrawals,
            'active_trades' => $activeTrades,
            'calc_total' => $totalBalance,
            'final_available' => $availableBalance
        ]);

        return max(0, $availableBalance);
    }

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'role' => 'integer',
    ];
}
