<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trade extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'crypto',
        'asset',
        'amount',
        'direction',
        'leverage',
        'status',
        'profit',
        'expiry_at',
        'purchase_price',
        'delivery_price',
        
    ];

    protected $casts = [
        'expiry_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
