<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KycVerification extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'document_type',
        'front_image_path',
        'back_image_path',
        'status',
        'rejection_reason',
        'first_name',
        'last_name',
        'email',
        'phone',
        'dob',
        'address_line',
        'city',
        'state',
        'nationality',
        'details_confirmed',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
