<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class UserMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        // Debug logging
        \Log::info('UserMiddleware Check', [
            'user_id' => $user ? $user->id : 'null',
            'user_email' => $user ? $user->email : 'null',
            'user_role' => $user ? $user->role : 'null',
            'requested_url' => $request->url(),
        ]);

        if (!$user || $user->role !== 0) {
            // Redirect non-regular users
            \Log::warning('UserMiddleware: Access Denied', [
                'user_id' => $user ? $user->id : 'null',
                'role' => $user ? $user->role : 'null',
                'redirecting_to' => 'home'
            ]);
            return redirect()->route('home');
        }

        \Log::info('UserMiddleware: Access Granted', ['user_id' => $user->id]);
        return $next($request);
    }
}
