<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        // Debug logging
        \Log::info('AdminMiddleware Check', [
            'user_id' => $user ? $user->id : 'null',
            'user_email' => $user ? $user->email : 'null',
            'user_role' => $user ? $user->role : 'null',
            'requested_url' => $request->url(),
        ]);

        if (!$user || $user->role !== 1) {
            // Redirect non-admin users
            \Log::warning('AdminMiddleware: Access Denied', [
                'user_id' => $user ? $user->id : 'null',
                'role' => $user ? $user->role : 'null',
                'redirecting_to' => 'home'
            ]);
            return redirect()->route('home');
        }

        \Log::info('AdminMiddleware: Access Granted', ['user_id' => $user->id]);
        return $next($request);
    }
}
