<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class MarketController extends Controller
{
    public function getData(Request $request)
    {
        $ids = $request->query('ids');
        
        // Default params
        $params = [
            'vs_currency' => 'usd',
            'order' => 'market_cap_desc',
            'per_page' => 50,
            'page' => 1,
            'sparkline' => 'false',
        ];

        if ($ids) {
            $params['ids'] = $ids;
        }

        try {
            $response = Http::withoutVerifying()->get('https://api.coingecko.com/api/v3/coins/markets', $params);
            
            if ($response->successful()) {
                return $response->json();
            }
            
            return response()->json(['error' => 'Failed to fetch data from CoinGecko'], $response->status());
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
