<?php

namespace App\Http\Controllers;

use App\Models\KycVerification;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class KycController extends Controller
{
    // Submit KYC Documents
    public function store(Request $request)
    {
        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'dob' => 'required|date',
            'address_line' => 'required|string|max:255',
            'city' => 'required|string|max:100',
            'state' => 'required|string|max:100',
            'nationality' => 'required|string|max:100',
            'document_type' => 'required|string|in:passport,id_card,driver_license',
            'front_image' => 'required|image|max:2048',
            'back_image' => 'nullable|image|max:2048',
            'details_confirmed' => 'required|accepted',
        ]);

        $user = Auth::user();

        // Check if already pending or approved
        $existing = KycVerification::where('user_id', $user->id)
            ->whereIn('status', ['pending', 'approved'])
            ->first();

        if ($existing) {
            return back()->withErrors(['message' => 'Your verification is already pending or approved.']);
        }

        // Store Files
        $frontPath = $request->file('front_image')->store('kyc-documents', 'public');
        $backPath = null;
        if ($request->hasFile('back_image')) {
            $backPath = $request->file('back_image')->store('kyc-documents', 'public');
        }

        KycVerification::create([
            'user_id' => $user->id,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'dob' => $request->dob,
            'address_line' => $request->address_line,
            'city' => $request->city,
            'state' => $request->state,
            'nationality' => $request->nationality,
            'document_type' => $request->document_type,
            'front_image_path' => $frontPath,
            'back_image_path' => $backPath,
            'details_confirmed' => true,
            'status' => 'pending',
        ]);

        return back()->with('success', 'KYC documents submitted successfully. Please wait for approval.');
    }
}
