<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\WalletTransaction;
use App\Models\User;

class AdminController extends Controller
{
    // Show Admin Dashboard
    public function home()
    {
        return Inertia::render('Admin/AdminHome', [
            'auth' => ['user' => auth()->user()],
        ]);
    }

    // Show Admin Wallet Transactions
    public function wallet()
    {
        $transactions = WalletTransaction::with('user')
            ->orderBy('created_at', 'desc')
            ->get();

        return Inertia::render('Admin/AdminWallet', [
            'auth' => ['user' => auth()->user()],
            'transactions' => $transactions,
        ]);
    }

    // Approve Transaction
    public function approveTransaction($id)
    {
        $transaction = WalletTransaction::findOrFail($id);

        if ($transaction->status !== 'pending') {
            return back()->with('error', 'Transaction already processed.');
        }

        $user = $transaction->user;
        $crypto = strtolower($transaction->crypto);

        if (!isset($user->wallet[$crypto])) {
            $user->wallet[$crypto] = 0;
        }

        if ($transaction->type === 'deposit') {
            $user->wallet[$crypto] += $transaction->amount;
        } elseif ($transaction->type === 'withdraw') {
            $user->wallet[$crypto] -= $transaction->amount;
        }

        $user->save();

        $transaction->status = 'approved';
        $transaction->save();

        return back()->with('success', 'Transaction approved successfully.');
    }

    // Decline Transaction
    public function declineTransaction($id)
    {
        $transaction = WalletTransaction::findOrFail($id);

        if ($transaction->status !== 'pending') {
            return back()->with('error', 'Transaction already processed.');
        }

        $transaction->status = 'declined';
        $transaction->save();

        return back()->with('success', 'Transaction declined.');
    }
}
