<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class TestEmail extends Command
{
    protected $signature = 'email:test {email}';
    protected $description = 'Test email sending';

    public function handle()
    {
        $email = $this->argument('email');
        
        $this->info('Testing email configuration...');
        $this->info('Sending to: ' . $email);
        
        try {
            Mail::raw('This is a test email from CoinSova. If you receive this, email is working!', function($message) use ($email) {
                $message->to($email)
                        ->subject('Test Email - CoinSova');
            });
            
            $this->info('✅ Email sent successfully!');
            $this->info('Check the inbox: ' . $email);
        } catch (\Exception $e) {
            $this->error('❌ Email failed to send!');
            $this->error('Error: ' . $e->getMessage());
        }
    }
}
