<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\VerificationCode;

class ShowVerificationCodes extends Command
{
    protected $signature = 'codes:show';
    protected $description = 'Show recent verification codes';

    public function handle()
    {
        $codes = VerificationCode::with('user')
            ->latest()
            ->take(10)
            ->get();

        if ($codes->isEmpty()) {
            $this->info('No verification codes found.');
            return;
        }

        $this->info('Recent Verification Codes:');
        $this->newLine();

        foreach ($codes as $code) {
            $this->line('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
            $this->line('Email: ' . $code->user->email);
            $this->line('Code: ' . $code->code);
            $this->line('Type: ' . $code->type);
            $this->line('Expires: ' . $code->expires_at->format('Y-m-d H:i:s'));
            $this->line('Status: ' . ($code->verified_at ? 'Verified' : 'Pending'));
            $this->newLine();
        }
    }
}
